/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UrlAbsolutizer {
    private final URI baseUri;

    public UrlAbsolutizer(@Nullable String baseUrl) {
        if (Strings.isNullOrEmpty((String)baseUrl)) {
            this.baseUri = null;
        } else {
            URI bu;
            if (!((String)baseUrl).endsWith("/")) {
                baseUrl = (String)baseUrl + "/";
            }
            if (!(bu = URI.create((String)baseUrl)).isAbsolute()) {
                throw new IllegalArgumentException("baseUrl is not absolute");
            }
            this.baseUri = bu;
        }
    }

    public boolean isValid() {
        return this.baseUri != null;
    }

    public String makeAbsolute(@Nonnull String relativeUrl) {
        Preconditions.checkNotNull(relativeUrl);
        if (this.baseUri == null) {
            return relativeUrl;
        }
        if (relativeUrl.isEmpty()) {
            return "";
        }
        while (relativeUrl.startsWith("/")) {
            relativeUrl = relativeUrl.substring(1);
        }
        return this.baseUri.resolve(relativeUrl).toString();
    }
}

